use "${tmp}/Regfile_nafZE", replace

cap drop tercile
gquantiles abvmedian = exposure if year == 2010 & exposure != 0, nq(2) xtile  by( ZE2010)
gquantiles tercile = exposure if year == 2010 & exposure != 0, nq(3) xtile  by(ZE2010) 
bys ZE2010 ape (abvmedian): replace abvmedian = abvmedian[1]
bys ZE2010 ape (tercile): replace tercile = tercile[1]
replace tercile = 1 if mi(tercile)
replace abvmedian = 1 if mi(abvmedian)


preserve
gcollapse (mean) ln_eng_sbrut (semean) se = ln_eng_sbrut, by(tercile year) 
save "$tmp/raw_data_terciles", replace
restore


gcollapse (mean) ln_eng_sbrut (semean) se = ln_eng_sbrut, by(tercile year) 
bys tercile: egen foo = max(ln_eng_sbrut*(year==2010))
replace ln_eng_sbrut = ln_eng_sbrut - foo
gen upper = ln_eng_sbrut + se
gen lower = ln_eng_sbrut - se
tw (connected ln_eng_sbrut year if tercile == 1) (connected ln_eng_sbrut year if tercile == 3)  (connected ln_eng_sbrut year if tercile == 2) ///
	 , legend( label(1 "Bottom tercile") label(3 "Middle tercile") label(2 "Top tercile") order(1 3 2) ring(0) pos(5) ) name(above_below, replace) yscale(fextend) xscale(fextend) xtitle("") xlab(2004(1)2019, nogrid) ytitle("Log of engineer wages (norm. in 2010)") xline(2010.5)
graph export  "${outpath}/FigureB1.pdf", as(pdf) replace


